<?php

declare(strict_types=1);

/*
 * PaypalServerSdkLib
 *
 * This file was automatically generated by APIMATIC v3.0 ( https://www.apimatic.io ).
 */

namespace PaypalServerSdkLib\Models;

use stdClass;

/**
 * Refunds a captured payment, by ID. For a full refund, include an empty request body. For a partial
 * refund, include an <code>amount</code> object in the request body.
 */
class RefundRequest implements \JsonSerializable
{
    /**
     * @var Money|null
     */
    private $amount;

    /**
     * @var string|null
     */
    private $customId;

    /**
     * @var string|null
     */
    private $invoiceId;

    /**
     * @var string|null
     */
    private $noteToPayer;

    /**
     * @var RefundPaymentInstruction|null
     */
    private $paymentInstruction;

    /**
     * Returns Amount.
     * The currency and amount for a financial transaction, such as a balance or payment due.
     */
    public function getAmount(): ?Money
    {
        return $this->amount;
    }

    /**
     * Sets Amount.
     * The currency and amount for a financial transaction, such as a balance or payment due.
     *
     * @maps amount
     */
    public function setAmount(?Money $amount): void
    {
        $this->amount = $amount;
    }

    /**
     * Returns Custom Id.
     * The API caller-provided external ID. Used to reconcile API caller-initiated transactions with PayPal
     * transactions. Appears in transaction and settlement reports. The pattern is defined by an external
     * party and supports Unicode.
     */
    public function getCustomId(): ?string
    {
        return $this->customId;
    }

    /**
     * Sets Custom Id.
     * The API caller-provided external ID. Used to reconcile API caller-initiated transactions with PayPal
     * transactions. Appears in transaction and settlement reports. The pattern is defined by an external
     * party and supports Unicode.
     *
     * @maps custom_id
     */
    public function setCustomId(?string $customId): void
    {
        $this->customId = $customId;
    }

    /**
     * Returns Invoice Id.
     * The API caller-provided external invoice ID for this order. The pattern is defined by an external
     * party and supports Unicode.
     */
    public function getInvoiceId(): ?string
    {
        return $this->invoiceId;
    }

    /**
     * Sets Invoice Id.
     * The API caller-provided external invoice ID for this order. The pattern is defined by an external
     * party and supports Unicode.
     *
     * @maps invoice_id
     */
    public function setInvoiceId(?string $invoiceId): void
    {
        $this->invoiceId = $invoiceId;
    }

    /**
     * Returns Note to Payer.
     * The reason for the refund. Appears in both the payer's transaction history and the emails that the
     * payer receives. The pattern is defined by an external party and supports Unicode.
     */
    public function getNoteToPayer(): ?string
    {
        return $this->noteToPayer;
    }

    /**
     * Sets Note to Payer.
     * The reason for the refund. Appears in both the payer's transaction history and the emails that the
     * payer receives. The pattern is defined by an external party and supports Unicode.
     *
     * @maps note_to_payer
     */
    public function setNoteToPayer(?string $noteToPayer): void
    {
        $this->noteToPayer = $noteToPayer;
    }

    /**
     * Returns Payment Instruction.
     * Any additional payments instructions during refund payment processing. This object is only
     * applicable to merchants that have been enabled for PayPal Commerce Platform for Marketplaces and
     * Platforms capability. Please speak to your account manager if you want to use this capability.
     */
    public function getPaymentInstruction(): ?RefundPaymentInstruction
    {
        return $this->paymentInstruction;
    }

    /**
     * Sets Payment Instruction.
     * Any additional payments instructions during refund payment processing. This object is only
     * applicable to merchants that have been enabled for PayPal Commerce Platform for Marketplaces and
     * Platforms capability. Please speak to your account manager if you want to use this capability.
     *
     * @maps payment_instruction
     */
    public function setPaymentInstruction(?RefundPaymentInstruction $paymentInstruction): void
    {
        $this->paymentInstruction = $paymentInstruction;
    }

    /**
     * Encode this object to JSON
     *
     * @param bool $asArrayWhenEmpty Whether to serialize this model as an array whenever no fields
     *        are set. (default: false)
     *
     * @return array|stdClass
     */
    #[\ReturnTypeWillChange] // @phan-suppress-current-line PhanUndeclaredClassAttribute for (php < 8.1)
    public function jsonSerialize(bool $asArrayWhenEmpty = false)
    {
        $json = [];
        if (isset($this->amount)) {
            $json['amount']              = $this->amount;
        }
        if (isset($this->customId)) {
            $json['custom_id']           = $this->customId;
        }
        if (isset($this->invoiceId)) {
            $json['invoice_id']          = $this->invoiceId;
        }
        if (isset($this->noteToPayer)) {
            $json['note_to_payer']       = $this->noteToPayer;
        }
        if (isset($this->paymentInstruction)) {
            $json['payment_instruction'] = $this->paymentInstruction;
        }

        return (!$asArrayWhenEmpty && empty($json)) ? new stdClass() : $json;
    }
}
