<?php

declare(strict_types=1);

/*
 * PaypalServerSdkLib
 *
 * This file was automatically generated by APIMATIC v3.0 ( https://www.apimatic.io ).
 */

namespace PaypalServerSdkLib\Models\Builders;

use Core\Utils\CoreHelper;
use PaypalServerSdkLib\Models\PaypalWalletExperienceContext;

/**
 * Builder for model PaypalWalletExperienceContext
 *
 * @see PaypalWalletExperienceContext
 */
class PaypalWalletExperienceContextBuilder
{
    /**
     * @var PaypalWalletExperienceContext
     */
    private $instance;

    private function __construct(PaypalWalletExperienceContext $instance)
    {
        $this->instance = $instance;
    }

    /**
     * Initializes a new paypal wallet experience context Builder object.
     */
    public static function init(): self
    {
        return new self(new PaypalWalletExperienceContext());
    }

    /**
     * Sets brand name field.
     */
    public function brandName(?string $value): self
    {
        $this->instance->setBrandName($value);
        return $this;
    }

    /**
     * Sets locale field.
     */
    public function locale(?string $value): self
    {
        $this->instance->setLocale($value);
        return $this;
    }

    /**
     * Sets shipping preference field.
     */
    public function shippingPreference(?string $value): self
    {
        $this->instance->setShippingPreference($value);
        return $this;
    }

    /**
     * Sets return url field.
     */
    public function returnUrl(?string $value): self
    {
        $this->instance->setReturnUrl($value);
        return $this;
    }

    /**
     * Sets cancel url field.
     */
    public function cancelUrl(?string $value): self
    {
        $this->instance->setCancelUrl($value);
        return $this;
    }

    /**
     * Sets landing page field.
     */
    public function landingPage(?string $value): self
    {
        $this->instance->setLandingPage($value);
        return $this;
    }

    /**
     * Sets user action field.
     */
    public function userAction(?string $value): self
    {
        $this->instance->setUserAction($value);
        return $this;
    }

    /**
     * Sets payment method preference field.
     */
    public function paymentMethodPreference(?string $value): self
    {
        $this->instance->setPaymentMethodPreference($value);
        return $this;
    }

    /**
     * Initializes a new paypal wallet experience context object.
     */
    public function build(): PaypalWalletExperienceContext
    {
        return CoreHelper::clone($this->instance);
    }
}
