@extends('layouts/contentLayoutMaster')

@section('title', __('locale.menu.Add Plugin'))

@section('content')
    <!-- Basic Vertical form layout section start -->
    <section id="basic-vertical-layouts">
        <div class="row match-height">
            <div class="col-md-6 col-12">

                <div class="card">
                    <div class="card-header">
                        <h4 class="card-title">{{ __('locale.menu.Add Plugin') }}</h4>
                    </div>
                    <div class="card-content">
                        <div class="card-body">

                            <p class="card-text">
                                {{__('locale.plugins.install_description')}}
                            </p>

                            <form class="form form-vertical" action="{{ route('admin.plugins.install') }}"
                                  method="post" enctype="multipart/form-data">
                                @csrf
                                <div class="row">

                                    <div class="col-12">
                                        <div class="mb-1">
                                            <label for="file"
                                                   class="form-label">{{__('locale.labels.choose_file')}}</label>
                                            <input type="file" name="file" class="form-control" id="file"
                                                   placeholder="{{ __('locale.labels.choose_file') }}"
                                                   accept="application/zip,application/octet-stream,application/zip,application/x-zip,application/x-zip-compressed" />
                                            @error('file')
                                            <p><small class="text-danger">{{ $message }}</small></p>
                                            @enderror
                                        </div>
                                    </div>

                                    <div class="col-12 mt-1">
                                        <button type="submit" class="btn btn-primary mr-1 mb-1"><i data-feather="upload"
                                                                                                   class="align-middle me-sm-25 me-0"></i> {{__('locale.labels.upload')}}
                                        </button>
                                    </div>


                                </div>
                            </form>
                        </div>

                    </div>
                </div>
            </div>


        </div>
    </section>
    <!-- // Basic Vertical form layout section end -->

@endsection


@section('page-script')

    <script>
      let firstInvalid = $("form").find(".is-invalid").eq(0);

      if (firstInvalid.length) {
        $("body, html").stop(true, true).animate({
          "scrollTop": firstInvalid.offset().top - 200 + "px"
        }, 200);
      }
    </script>
@endsection
