<?php

declare(strict_types=1);

/*
 * PaypalServerSdkLib
 *
 * This file was automatically generated by APIMATIC v3.0 ( https://www.apimatic.io ).
 */

namespace PaypalServerSdkLib\Models\Builders;

use Core\Utils\CoreHelper;
use PaypalServerSdkLib\Models\Address;
use PaypalServerSdkLib\Models\Name;
use PaypalServerSdkLib\Models\PaypalWalletAttributesResponse;
use PaypalServerSdkLib\Models\PaypalWalletResponse;
use PaypalServerSdkLib\Models\PhoneNumber;
use PaypalServerSdkLib\Models\TaxInfo;

/**
 * Builder for model PaypalWalletResponse
 *
 * @see PaypalWalletResponse
 */
class PaypalWalletResponseBuilder
{
    /**
     * @var PaypalWalletResponse
     */
    private $instance;

    private function __construct(PaypalWalletResponse $instance)
    {
        $this->instance = $instance;
    }

    /**
     * Initializes a new paypal wallet response Builder object.
     */
    public static function init(): self
    {
        return new self(new PaypalWalletResponse());
    }

    /**
     * Sets email address field.
     */
    public function emailAddress(?string $value): self
    {
        $this->instance->setEmailAddress($value);
        return $this;
    }

    /**
     * Sets account id field.
     */
    public function accountId(?string $value): self
    {
        $this->instance->setAccountId($value);
        return $this;
    }

    /**
     * Sets account status field.
     */
    public function accountStatus(?string $value): self
    {
        $this->instance->setAccountStatus($value);
        return $this;
    }

    /**
     * Sets name field.
     */
    public function name(?Name $value): self
    {
        $this->instance->setName($value);
        return $this;
    }

    /**
     * Sets phone type field.
     */
    public function phoneType(?string $value): self
    {
        $this->instance->setPhoneType($value);
        return $this;
    }

    /**
     * Sets phone number field.
     */
    public function phoneNumber(?PhoneNumber $value): self
    {
        $this->instance->setPhoneNumber($value);
        return $this;
    }

    /**
     * Sets birth date field.
     */
    public function birthDate(?string $value): self
    {
        $this->instance->setBirthDate($value);
        return $this;
    }

    /**
     * Sets business name field.
     */
    public function businessName(?string $value): self
    {
        $this->instance->setBusinessName($value);
        return $this;
    }

    /**
     * Sets tax info field.
     */
    public function taxInfo(?TaxInfo $value): self
    {
        $this->instance->setTaxInfo($value);
        return $this;
    }

    /**
     * Sets address field.
     */
    public function address(?Address $value): self
    {
        $this->instance->setAddress($value);
        return $this;
    }

    /**
     * Sets attributes field.
     */
    public function attributes(?PaypalWalletAttributesResponse $value): self
    {
        $this->instance->setAttributes($value);
        return $this;
    }

    /**
     * Initializes a new paypal wallet response object.
     */
    public function build(): PaypalWalletResponse
    {
        return CoreHelper::clone($this->instance);
    }
}
