<?php

declare(strict_types=1);

/*
 * PaypalServerSdkLib
 *
 * This file was automatically generated by APIMATIC v3.0 ( https://www.apimatic.io ).
 */

namespace PaypalServerSdkLib\Models\Builders;

use Core\Utils\CoreHelper;
use PaypalServerSdkLib\Models\Address;
use PaypalServerSdkLib\Models\Name;
use PaypalServerSdkLib\Models\PaypalPaymentToken;
use PaypalServerSdkLib\Models\Phone;
use PaypalServerSdkLib\Models\PhoneWithType;
use PaypalServerSdkLib\Models\VaultedDigitalWalletShippingDetails;

/**
 * Builder for model PaypalPaymentToken
 *
 * @see PaypalPaymentToken
 */
class PaypalPaymentTokenBuilder
{
    /**
     * @var PaypalPaymentToken
     */
    private $instance;

    private function __construct(PaypalPaymentToken $instance)
    {
        $this->instance = $instance;
    }

    /**
     * Initializes a new paypal payment token Builder object.
     */
    public static function init(): self
    {
        return new self(new PaypalPaymentToken());
    }

    /**
     * Sets description field.
     */
    public function description(?string $value): self
    {
        $this->instance->setDescription($value);
        return $this;
    }

    /**
     * Sets shipping field.
     */
    public function shipping(?VaultedDigitalWalletShippingDetails $value): self
    {
        $this->instance->setShipping($value);
        return $this;
    }

    /**
     * Sets permit multiple payment tokens field.
     */
    public function permitMultiplePaymentTokens(?bool $value): self
    {
        $this->instance->setPermitMultiplePaymentTokens($value);
        return $this;
    }

    /**
     * Sets usage type field.
     */
    public function usageType(?string $value): self
    {
        $this->instance->setUsageType($value);
        return $this;
    }

    /**
     * Sets customer type field.
     */
    public function customerType(?string $value): self
    {
        $this->instance->setCustomerType($value);
        return $this;
    }

    /**
     * Sets email address field.
     */
    public function emailAddress(?string $value): self
    {
        $this->instance->setEmailAddress($value);
        return $this;
    }

    /**
     * Sets payer id field.
     */
    public function payerId(?string $value): self
    {
        $this->instance->setPayerId($value);
        return $this;
    }

    /**
     * Sets name field.
     */
    public function name(?Name $value): self
    {
        $this->instance->setName($value);
        return $this;
    }

    /**
     * Sets phone field.
     */
    public function phone(?PhoneWithType $value): self
    {
        $this->instance->setPhone($value);
        return $this;
    }

    /**
     * Sets address field.
     */
    public function address(?Address $value): self
    {
        $this->instance->setAddress($value);
        return $this;
    }

    /**
     * Sets account id field.
     */
    public function accountId(?string $value): self
    {
        $this->instance->setAccountId($value);
        return $this;
    }

    /**
     * Sets phone number field.
     */
    public function phoneNumber(?Phone $value): self
    {
        $this->instance->setPhoneNumber($value);
        return $this;
    }

    /**
     * Initializes a new paypal payment token object.
     */
    public function build(): PaypalPaymentToken
    {
        return CoreHelper::clone($this->instance);
    }
}
