<?php

declare(strict_types=1);

/*
 * PaypalServerSdkLib
 *
 * This file was automatically generated by APIMATIC v3.0 ( https://www.apimatic.io ).
 */

namespace PaypalServerSdkLib\Models\Builders;

use Core\Utils\CoreHelper;
use PaypalServerSdkLib\Models\ApplePayRequest;
use PaypalServerSdkLib\Models\CardRequest;
use PaypalServerSdkLib\Models\GooglePayRequest;
use PaypalServerSdkLib\Models\OrderCaptureRequestPaymentSource;
use PaypalServerSdkLib\Models\PaypalWallet;
use PaypalServerSdkLib\Models\Token;
use PaypalServerSdkLib\Models\VenmoWalletRequest;

/**
 * Builder for model OrderCaptureRequestPaymentSource
 *
 * @see OrderCaptureRequestPaymentSource
 */
class OrderCaptureRequestPaymentSourceBuilder
{
    /**
     * @var OrderCaptureRequestPaymentSource
     */
    private $instance;

    private function __construct(OrderCaptureRequestPaymentSource $instance)
    {
        $this->instance = $instance;
    }

    /**
     * Initializes a new order capture request payment source Builder object.
     */
    public static function init(): self
    {
        return new self(new OrderCaptureRequestPaymentSource());
    }

    /**
     * Sets card field.
     */
    public function card(?CardRequest $value): self
    {
        $this->instance->setCard($value);
        return $this;
    }

    /**
     * Sets token field.
     */
    public function token(?Token $value): self
    {
        $this->instance->setToken($value);
        return $this;
    }

    /**
     * Sets paypal field.
     */
    public function paypal(?PaypalWallet $value): self
    {
        $this->instance->setPaypal($value);
        return $this;
    }

    /**
     * Sets apple pay field.
     */
    public function applePay(?ApplePayRequest $value): self
    {
        $this->instance->setApplePay($value);
        return $this;
    }

    /**
     * Sets google pay field.
     */
    public function googlePay(?GooglePayRequest $value): self
    {
        $this->instance->setGooglePay($value);
        return $this;
    }

    /**
     * Sets venmo field.
     */
    public function venmo(?VenmoWalletRequest $value): self
    {
        $this->instance->setVenmo($value);
        return $this;
    }

    /**
     * Initializes a new order capture request payment source object.
     */
    public function build(): OrderCaptureRequestPaymentSource
    {
        return CoreHelper::clone($this->instance);
    }
}
