<?php

    namespace App\Http\Controllers\Admin;

    use App\Exceptions\GeneralException;
    use App\Http\Requests\Plugins\InstallPluginRequest;
    use App\Models\Plugins;
    use App\Repositories\Contracts\PluginsRepository;
    use Exception;
    use Illuminate\Contracts\Foundation\Application;
    use Illuminate\Contracts\View\Factory;
    use Illuminate\Contracts\View\View;
    use Illuminate\Http\RedirectResponse;

    class PluginsController extends AdminBaseController
    {


        protected PluginsRepository $plugins;


        /**
         * Create a new controller instance.
         *
         * @param PluginsRepository $plugins
         */
        public function __construct(PluginsRepository $plugins)
        {
            $this->plugins = $plugins;
        }


        /**
         * @return Application|Factory|View
         */
        public function plugins(): View|Factory|Application
        {

            $this->authorize('view plugins');

            $pageConfigs = [
                'bodyClass' => 'ecommerce-application',
            ];

            $breadcrumbs = [
                ['link' => url(config('app.admin_path') . "/dashboard"), 'name' => __('locale.menu.Dashboard')],
                ['name' => __('locale.menu.Plugins')],
            ];


            return view('admin.Plugins.index', [
                'pageConfigs' => $pageConfigs,
                'breadcrumbs' => $breadcrumbs,
            ]);
        }


        /**
         * Shows the plugin installation page.
         *
         * This page is responsible for showing the plugin installation page.
         *
         * @return View
         */
        public function install()
        {

            $this->authorize('install plugins');

            $pageConfigs = [
                'bodyClass' => 'ecommerce-application',
            ];

            $breadcrumbs = [
                ['link' => url(config('app.admin_path') . "/dashboard"), 'name' => __('locale.menu.Dashboard')],
                ['link' => url(config('app.admin_path') . "/plugins"), 'name' => __('locale.menu.Plugins')],
                ['name' => __('locale.menu.Add Plugin')],
            ];

            return view('admin.Plugins.install', [
                'pageConfigs' => $pageConfigs,
                'breadcrumbs' => $breadcrumbs,
            ]);

        }


        /**
         * Handle uploaded plugin
         *
         * @param InstallPluginRequest $request
         * @return RedirectResponse
         * @throws GeneralException|Exception
         */
        public function upload(InstallPluginRequest $request): RedirectResponse
        {
            // Upload
            $pluginName = $this->plugins->upload($request);

            dd($pluginName);

            // Install Plugin
            Plugins::installFromDir($pluginName);

            return redirect()->route('admin.plugins')->with([
                'status'  => 'success',
                'message' => __('locale.plugins.installed'),
            ]);

        }

    }
